// UEFILibTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "Uefi.h"


int _tmain(int argc, _TCHAR* argv[])
{
	CHAR16 cpBuffer1[128];
	CHAR16 cpBuffer2[128];
	CHAR16 Destination[512];
	CHAR16 format[10];
	StrCpy(format, L"\%ls");
	memset(Destination, 0, 512);
	Print(L"Test");
	AsciiStrToUnicodeStr("This is the string we want to copy into 'Destination'", Destination);

	// ZeroMem
	CHAR8 zeroMemBuffer[256];
	ZeroMem(zeroMemBuffer, 256);
	for(int i = 0; i < 256; i++)
		assert(zeroMemBuffer[i] == '\0');

	// ShellOpenFileByName, ShellCloseFile, FileHandleReadLine
	SHELL_FILE_HANDLE FileHandleReadLineHandle;
	CHAR16 FileHandleReadLineBuffer[256];
	UINTN FileHandleReadLineSize = 256;
	BOOLEAN FileHandleReadLineAscii;
	int FileHandleReadLineStatus = ShellOpenFileByName(L"PS_def.sDef", &FileHandleReadLineHandle, EFI_FILE_MODE_READ, 0);
	assert(FileHandleReadLineStatus == EFI_SUCCESS);
	FileHandleReadLineStatus = FileHandleReadLine(FileHandleReadLineHandle, FileHandleReadLineBuffer, &FileHandleReadLineSize, TRUE, &FileHandleReadLineAscii);
	assert(FileHandleReadLineStatus == EFI_SUCCESS);
	assert(StrCmp(FileHandleReadLineBuffer, L"//FILE_HEADER") == 0);
	//FileHandleReadLineStatus = FileHandlePrintLine(FileHandleReadLineHandle, format);
	//assert(FileHandleReadLineStatus == EFI_SUCCESS);
	FileHandleReadLineStatus = ShellCloseFile(&FileHandleReadLineHandle);
	assert(FileHandleReadLineStatus == EFI_SUCCESS);

	// FileHandleWriteLine
	/**
	SHELL_FILE_HANDLE FileHandleWriteLineHandle;
	SHELL_FILE_HANDLE FileHandleWriteLineReadHandle;
	CHAR16 FileHandleWriteLineBuffer[1024];
	CHAR16 FileHandleWriteLineReadBuffer[1024];
	UINTN FileHandleWriteLineReadSize = 1024;
	BOOLEAN FileHandleWriteLineReadAscii;
	memset(FileHandleWriteLineBuffer, 0, 1024);
	memset(FileHandleWriteLineReadBuffer, 0, 1024);
	StrCpy(FileHandleWriteLineBuffer, L"Write to LLK_test.txt");  // Create the file before running code!

	int FileHandleWriteLineStatus = ShellOpenFileByName(L"LLK_test.txt", &FileHandleWriteLineHandle, EFI_FILE_MODE_WRITE, 0);
	assert(FileHandleWriteLineStatus == EFI_SUCCESS);
	FileHandleWriteLineStatus = FileHandleWriteLine(FileHandleWriteLineHandle, FileHandleWriteLineBuffer);
	assert(FileHandleWriteLineStatus == EFI_SUCCESS);
	FileHandleWriteLineStatus = ShellCloseFile(&FileHandleWriteLineHandle);
	assert(FileHandleWriteLineStatus == EFI_SUCCESS);

	FileHandleWriteLineStatus = ShellOpenFileByName(L"LLK_test.txt", &FileHandleWriteLineReadHandle, EFI_FILE_MODE_READ, 0);
	assert(FileHandleWriteLineStatus == EFI_SUCCESS);
	FileHandleWriteLineStatus = FileHandleReadLine(FileHandleWriteLineReadHandle, FileHandleWriteLineReadBuffer, &FileHandleWriteLineReadSize, TRUE, &FileHandleWriteLineReadAscii);
	assert(FileHandleWriteLineStatus == EFI_SUCCESS);
	assert(StrCmp(FileHandleWriteLineReadBuffer, L"Write to LLK_test.txt") == 0);
	FileHandleWriteLineStatus = ShellCloseFile(&FileHandleWriteLineReadHandle);
	assert(FileHandleWriteLineStatus == EFI_SUCCESS); **/

	// ShellWriteFile, AsciiStrToUnicodeStr
	SHELL_FILE_HANDLE ShellWriteFileHandle;
	SHELL_FILE_HANDLE ShellWriteFileReadHandle;

	CHAR8  myBuffer[1024];
	CHAR16 ShellWriteFileBuffer[1024];
	CHAR16 ShellWriteFileReadBuffer[1024];
	CHAR16 *ShellWriteFileReturnBuffer;
	UINTN ShellWriteFileReadSize = 1024;
	BOOLEAN ShellWriteFileReadAscii;

	memset(ShellWriteFileBuffer, 0, 1024);
	memset(ShellWriteFileReadBuffer, 0, 1024);

	for (int i = 0; i < 1024; i++) {
		myBuffer[i] = 70;    // initialize all array elements with 'F'
		if ( (i >= 48) && (i <= 57) ) {
			myBuffer[i-48] = i;
		} else if ( (i >= 65) && (i <= 90) ) {
			myBuffer[i - 55] = i;
		}
		else if ( (i >= 97) && (i <= 122) ) {
			myBuffer[i- 61] = i;
		}
	}

	myBuffer[1023] = '\0';

	ShellWriteFileReturnBuffer = AsciiStrToUnicodeStr(myBuffer, ShellWriteFileBuffer);
	assert(StrCmp(ShellWriteFileBuffer, ShellWriteFileReturnBuffer) == 0);

	int ShellWriteFileStatus = ShellOpenFileByName(L"LLK_test2.txt", &ShellWriteFileHandle, EFI_FILE_MODE_WRITE, 0);
	assert(ShellWriteFileStatus == EFI_SUCCESS);
	ShellWriteFileStatus = ShellWriteFile(ShellWriteFileHandle, &ShellWriteFileReadSize, ShellWriteFileBuffer);
	assert(ShellWriteFileStatus == EFI_SUCCESS);
	ShellWriteFileStatus = ShellCloseFile(&ShellWriteFileHandle);
	assert(ShellWriteFileStatus == EFI_SUCCESS);

	// ShellConvertStringToUint64
	CHAR16 myDec1[20];
	CHAR16 myHex1[20];
	CHAR16 myHex2[20];
	CHAR16 myHex3[20];

	UINT64 myValue = 0;

	memset(myDec1, 0, 20);
	memset(myHex1, 0, 20);
	memset(myHex2, 0, 20);
	memset(myHex3, 0, 20);

	StrCpy(myDec1, L"1234567890");
	StrCpy(myHex1, L"0x123456789A");
	StrCpy(myHex2, L"0XABCdEF123456");
	StrCpy(myHex3, L"BEEF");

	int ShellConvertStringToUint64Status = ShellConvertStringToUint64(myDec1, &myValue, FALSE, FALSE);
	assert(ShellConvertStringToUint64Status == EFI_SUCCESS);
	assert(myValue == 1234567890);

	ShellConvertStringToUint64Status = ShellConvertStringToUint64(myHex1, &myValue, TRUE, FALSE);
	assert(ShellConvertStringToUint64Status == EFI_SUCCESS);
	assert(myValue == 0x123456789A);

	ShellConvertStringToUint64Status = ShellConvertStringToUint64(myHex2, &myValue, TRUE, FALSE);
	assert(ShellConvertStringToUint64Status == EFI_SUCCESS);
	assert(myValue == 0XABCdEF123456);

	ShellConvertStringToUint64Status = ShellConvertStringToUint64(myHex3, &myValue, TRUE, FALSE);
	assert(ShellConvertStringToUint64Status == EFI_SUCCESS);
	assert(myValue == 0xBEEF);

	// CopyMem
	CHAR8 copyMemBufferSrc[16];
	CHAR8 copyMemBufferDst[16];
	for(int i = 0; i < 16; i++)
		copyMemBufferSrc[i] = i;
	CopyMem(copyMemBufferDst, copyMemBufferSrc, 16);
	assert(memcmp(copyMemBufferDst, copyMemBufferSrc, 16) == 0);

	// StrCpy
	memset(cpBuffer1, 0, 128);
	memset(cpBuffer2, 0, 128);
	wcscpy(cpBuffer1, L"This is a string, from cpBuffer1, we are copying using StrCpy() to 'cpBuffer2'");
	StrCpy(cpBuffer2, cpBuffer1);
	ASSERT(StrCmp(cpBuffer1, cpBuffer2) == 0);

	// StrnCpy
	memset(cpBuffer1, 0, 128);
	memset(cpBuffer2, 0, 128);
	wcscpy(cpBuffer1, L"This is a string, from cpBuffer1, we are copying using StrCpy() to 'cpBuffer2'");
	StrnCpy(cpBuffer2, cpBuffer1, 33);
	ASSERT(StrCmp(cpBuffer2, L"This is a string, from cpBuffer1,") == 0);

	// StrCmp
	memset(cpBuffer1, 0, 128);
	memset(cpBuffer2, 0, 128);
	StrCpy(cpBuffer1, L"This is a string, from cpBuffer1, we are copying using StrCpy() to 'cpBuffer2'");
	StrCpy(cpBuffer2, L"This is a sting, from cpBuffer1, we are copying using StrCpy() to 'cpBuffer2'");
	ASSERT(StrCmp(cpBuffer1, cpBuffer2) >  0);

	// StrnCmp
	memset(cpBuffer1, 0, 128);
	memset(cpBuffer2, 0, 128);
	StrCpy(cpBuffer1, L"This is a string, from cpBuffer1, we are copying using StrCpy() to 'cpBuffer2'");
	StrCpy(cpBuffer2, L"This is a sting, from cpBuffer1, we are copying using StrCpy() to 'cpBuffer2'");
	ASSERT(StrnCmp(cpBuffer2, cpBuffer1, 12) == 0);
	ASSERT(StrnCmp(cpBuffer2, cpBuffer1, 13) < 0);

	// StrLen
	memset(cpBuffer1, 0, 128);
	memset(cpBuffer2, 0, 128);
	StrCpy(cpBuffer1, L"This is a string, from cpBuffer1, we are copying using StrCpy() to 'cpBuffer2'");
	ASSERT(StrLen(cpBuffer1) == 78);

	// StrCat
	memset(cpBuffer1, 0, 128);
	StrCpy(cpBuffer1, L"This is a string, from cpBuffer1, we are copying using StrCpy() to ");
	StrCat(cpBuffer1, L"'cpBuffer2'");
	ASSERT(StrCmp(cpBuffer1, L"This is a string, from cpBuffer1, we are copying using StrCpy() to 'cpBuffer2'") == 0);

	// StrStr
	memset(cpBuffer1, 0, 128);
	StrCpy(cpBuffer1, L"This is the string from cpBuffer1 and we are going to search for \"Substring\"");
	CHAR16 *StrStrRetValue = StrStr(cpBuffer1, L"Substring");
	ASSERT(StrStrRetValue != NULL);
	ASSERT(StrnCmp(StrStrRetValue, L"Substring", 9) == 0);

	// UnicodeSPrint
	CHAR16 unicodeSPrintBuffer[128];
	UnicodeSPrint(unicodeSPrintBuffer, 128, L"This is a %ls, print the number %d", L"test", 45);
	assert(StrCmp(unicodeSPrintBuffer, L"This is a test, print the number 45") == 0);

	// AllocateZeroPool, FreePool
	VOID *allocZeroMemBuffer = AllocateZeroPool(128 * sizeof(CHAR16));
	assert(allocZeroMemBuffer != 0);
	FreePool(allocZeroMemBuffer);

	
	// The End
	UefiSetConsoleTextColor(WinConsoleColor_Green);
	puts("\n\nTest Complete!");
	UefiSetConsoleTextColor(WinConsoleColor_DarkWhite);
	puts("\nPress the Enter key to exit");
	getchar();

	return 0;
} 

